// LayoutSkinDlg.cpp : t@C
//

#include "stdafx.h"
#include "PCRPlayer.h"
#include "SkinConfigDlg.h"
#include "afxdialogex.h"


// CSkinConfigDlg _CAO

IMPLEMENT_DYNAMIC(CSkinConfigDlg, CBasePropDlg)

CSkinConfigDlg::CSkinConfigDlg(utl::PropSetting& setting, const std::wstring& skin, COLORREF back, int name, bool id, bool splitter)
	: CBasePropDlg(setting)
	, cfg_(skin, back, name, id)
	, this_(skin, back, name, id, splitter)
{

}

CSkinConfigDlg::~CSkinConfigDlg()
{
}



void CSkinConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CBasePropDlg::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CSkinConfigDlg, CBasePropDlg)
	ON_BN_CLICKED(IDC_BTN_SAMPLE1, &CSkinConfigDlg::OnBnClickedBtnSample1)
	ON_BN_CLICKED(IDC_BTN_SAMPLE2, &CSkinConfigDlg::OnBnClickedBtnSample2)
END_MESSAGE_MAP()


// CSkinConfigDlg bZ[W nh[


BOOL CSkinConfigDlg::OnInitDialog()
{
	CBasePropDlg::OnInitDialog();

	auto bindColor = [this](CMFCPropertyGridProperty* group, const std::wstring& name, bbs::SkinConfig::TextColor& value){
		auto color = prop_.color(
			L"[Ȃ", value.text, L"<&" + name + L"TextColor/>\r\n[ɕ񂪂ȂƂ̕F");
		group->AddSubItem(color);

		color = prop_.color(
			L"[", value.link, L"<&" + name + L"LinkColor/>\r\n[ɕ񂪂Ƃ̕F");
		group->AddSubItem(color);

		color = prop_.color(
			L"[sage", value.sage, L"<&" + name + L"SageColor/>\r\n[ \"sage\" ̂Ƃ̕F");
		group->AddSubItem(color);
	};

	auto group = prop_.group(L"S");
	prop_.add(group);
	{
		auto skin = prop_.string(L"XL", cfg_.skin);
		for (auto it = this_.skins.begin(); it != this_.skins.end(); ++it)
		{
			skin->AddOption(it->c_str());
		}
		skin->AllowEdit(FALSE);
		group->AddSubItem(skin);

		cfg_.font.get(this_.lf);
		auto font = prop_.font(L"tHg", this_.lf,
			L"<&FontName/> tHg\r\n<&FontPoint/><&FontPixel/> tHg|Cg/sNZ");
		group->AddSubItem(font);
	}

	group = prop_.group(L"zF");
	prop_.add(group);
	{
		auto desc = [](const std::wstring& name)->std::wstring {
				return L"<&" + name + L"Color/>\r\n"
				L"F̐lɒu܂ (F#f0f0f0)\r\n"
				L"`FbNO \"transparent\" ɒu܂";
		};

		auto color = prop_.color(cfg_.color.text.enable, L"", cfg_.color.text.color, desc(L"Text"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.message.enable, L"{", cfg_.color.message.color, desc(L"Message"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.link.enable, L"N", cfg_.color.link.color, desc(L"Link"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.back.enable, L"wi", cfg_.color.back.color, desc(L"Back"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.newly.enable, L"V", cfg_.color.newly.color, desc(L"New"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.border.enable, L"{[_[", cfg_.color.border.color, desc(L"Border"));
		group->AddSubItem(color);

		color = prop_.color(cfg_.color.scroll.enable, L"XN[o[", cfg_.color.scroll.color, desc(L"Scroll"));
		group->AddSubItem(color);
	}

	if (this_.splitter)
	{
		auto group = prop_.group(L"Xvb^");
		prop_.add(group);
		{
			auto number = prop_.number(L"", splitter_.split);
			number->EnableSpinControl(TRUE, 0, 100);
			group->AddSubItem(number);

			auto check = prop_.check(L"3DGbW", splitter_.edge);
			group->AddSubItem(check);

			auto color = prop_.color(L"\", splitter_.face);
			group->AddSubItem(color);
			check->AddLink(color, TRUE);

			color = prop_.color(L"{[_[J[", splitter_.border);
			group->AddSubItem(color);
			check->AddLink(color, TRUE);
		}
	}

	group = prop_.group(L"O");
	prop_.add(group);
	{
		auto combo = prop_.combo(L"", cfg_.name.format,
			L"Ȍݒ肵܂\r\n\"ftHĝ\"ɂƌf̃ftHgȊO̖OgbvALbv̂ݕ\ăftHg͕\܂");
		combo->AddComboValue(L"ʏ", bbs::SKIN_NAME_FORMAT_NORMAL);
		combo->AddComboValue(L"ftHĝ", bbs::SKIN_NAME_FORMAT_NODEFAULT);
		group->AddSubItem(combo);

		auto check = prop_.check(
			L"", cfg_.name.bold,
			L"O𑾎ŕ\܂\r\n"
			L"gbvALbv͖{Ƌʂ邽ߑɂ͂Ȃ܂\r\n"
			L"XLŖO𑾎ɂĂꍇ𖳌ɂ͂ł܂"
		);
		group->AddSubItem(check);

		bindColor(group, L"Name", cfg_.name.color);
	}

	group = prop_.group(L"[");
	prop_.add(group);
	{
		bindColor(group, L"Mail", cfg_.mail.color);
	}

	group = prop_.group(L"");
	prop_.add(group);
	{
		bindColor(group, L"Time", cfg_.time.color);
	}

	group = prop_.group(L"Xԍ");
	prop_.add(group);
	{
		auto color = prop_.color(
			L"AJ[QƐ0", cfg_.number.color.first);
		group->AddSubItem(color);

		color = prop_.color(
			L"AJ[QƐ1ȏ", cfg_.number.color.second);
		group->AddSubItem(color);

		color = prop_.color(
			L"AJ[QƐlȏ", cfg_.number.color.third);
		group->AddSubItem(color);

		auto number = prop_.number(
			L"l", cfg_.number.threshold);
		group->AddSubItem(number);
	}

	group = prop_.group(L"ID");
	prop_.add(group);
	{
		auto check = prop_.check(
			L"ID̉ɔ񐔂\", cfg_.id.enable);
		group->AddSubItem(check);

		auto color = prop_.color(
			L"1", cfg_.id.color.first);
		group->AddSubItem(color);

		color = prop_.color(
			L"2ȏ", cfg_.id.color.second);
		group->AddSubItem(color);

		color = prop_.color(
			L"lȏ", cfg_.id.color.third);
		group->AddSubItem(color);

		auto number = prop_.number(
			L"l", cfg_.id.threshold);
		group->AddSubItem(number);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
				  // O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CSkinConfigDlg::OnBnClickedBtnSample1()
{
	prop_.get();
	cfg_.font.set(this_.lf);

	splitter_.edge = false;
	splitter_.face = RGB(16, 16, 16);
	splitter_.border = RGB(32, 32, 32);

	cfg_.color.text.enable = true;
	cfg_.color.text.color = RGB(160, 160, 160);
	cfg_.color.message.enable = true;
	cfg_.color.message.color = RGB(255, 255, 255);
	cfg_.color.link.enable = true;
	cfg_.color.link.color = RGB(128, 128, 255);
	cfg_.color.back.enable = true;
	cfg_.color.back.color = RGB(16, 16, 16);
	cfg_.color.newly.enable = true;
	cfg_.color.newly.color = RGB(16, 16, 64);
	cfg_.color.border.enable = true;
	cfg_.color.border.color = RGB(32, 32, 32);
	cfg_.color.scroll.enable = true;
	cfg_.color.scroll.color = RGB(16, 16, 16);

	cfg_.name.color.text = RGB(128, 255, 128);
	cfg_.name.color.link = RGB(128, 128, 255);
	cfg_.name.color.sage = RGB(255, 128, 255);

	cfg_.mail.color.text = RGB(128, 255, 128);
	cfg_.mail.color.link = RGB(128, 128, 255);
	cfg_.mail.color.sage = RGB(255, 128, 255);

	cfg_.time.color.text = RGB(128, 255, 128);
	cfg_.time.color.link = RGB(128, 128, 255);
	cfg_.time.color.sage = RGB(255, 128, 255);

	cfg_.number.color.first = RGB(128, 128, 255);
	cfg_.number.color.second = RGB(255, 128, 255);
	cfg_.number.color.third = RGB(255, 128, 128);

	cfg_.id.color.first = RGB(192, 192, 192);
	cfg_.id.color.second = RGB(128, 128, 255);
	cfg_.id.color.third = RGB(255, 128, 128);

	prop_.set();

	m_xcProp.RedrawWindow();
}

void CSkinConfigDlg::OnBnClickedBtnSample2()
{
	auto tmp = bbs::SkinConfig(this_.skin, this_.back, this_.name, this_.id);
	auto splitter = sl::SplitterConfig();

	prop_.get();
	cfg_.font.set(this_.lf);

	splitter_.edge = false;
	splitter_.face = splitter.face;
	splitter_.border = splitter.border;

	cfg_.color = tmp.color;
	cfg_.name.color = tmp.name.color;
	cfg_.mail.color = tmp.mail.color;
	cfg_.time.color = tmp.time.color;
	cfg_.number.color = tmp.number.color;
	cfg_.id.color = tmp.id.color;

	prop_.set();

	m_xcProp.RedrawWindow();
}

void CSkinConfigDlg::OnGetProp()
{
	prop_.get();
	cfg_.font.set(this_.lf);
}

void CSkinConfigDlg::OnSetProp()
{
	cfg_ = bbs::SkinConfig(this_.skin, this_.back, this_.name, this_.id);
	splitter_ = sl::SplitterConfig();

	cfg_.font.get(this_.lf);
	prop_.set();
}

