#pragma once

namespace sl {

////////////////////////////////////////////////////////////////////////
// \ݒ

// {
struct WindowZoom {
	WindowZoom()
		: enable(true), zoom(100)
	{}

	WindowZoom(bool enable, int zoom)
		: enable(enable), zoom(zoom)
	{}

	bool enable; // L
	int zoom; // {
};

// TCY
struct WindowSize {
	WindowSize()
		: enable(true), width(800), height(600)
	{}

	WindowSize(bool enable, int width, int height)
		: enable(enable), width(width), height(height)
	{}

	bool enable; // L
	int width; // EBhE
	int height; // EBhE
};

// AXyNg
struct WindowAspect {
	WindowAspect()
		: ax(4), ay(3)
	{}

	WindowAspect(int ax, int ay)
		: ax(ax), ay(ay)
	{}

	int ax; // 䗦
	int ay; // 䗦
};

// EBhE
struct WindowConfig {
	WindowConfig()
	{
		zoom.push_back(WindowZoom(true, 25));
		zoom.push_back(WindowZoom(true, 50));
		zoom.push_back(WindowZoom(true, 75));
		zoom.push_back(WindowZoom(true, 100));
		zoom.push_back(WindowZoom(true, 125));
		zoom.push_back(WindowZoom(true, 150));
		zoom.push_back(WindowZoom(true, 200));


		size.push_back(WindowSize(false, 320, 180));
		size.push_back(WindowSize(false, 352, 200));
		size.push_back(WindowSize(false, 480, 270));
		size.push_back(WindowSize(true, 640, 360));
		size.push_back(WindowSize(true, 800, 450));
		size.push_back(WindowSize(true, 960, 540));
		size.push_back(WindowSize(false, 1024, 576));
		size.push_back(WindowSize(true, 1280, 720));
		size.push_back(WindowSize(false, 1440, 810));
		size.push_back(WindowSize(false, 1600, 900));
		size.push_back(WindowSize(false, 1920, 1080));

		size.push_back(WindowSize(true, 320, 240));
		size.push_back(WindowSize(true, 480, 360));
		size.push_back(WindowSize(false, 512, 384));
		size.push_back(WindowSize(true, 640, 480));
		size.push_back(WindowSize(true, 800, 600));
		size.push_back(WindowSize(false, 960, 720));
		size.push_back(WindowSize(false, 1024, 768));
		size.push_back(WindowSize(false, 1280, 960));
		size.push_back(WindowSize(false, 1440, 1080));
		size.push_back(WindowSize(false, 1600, 1200));
		size.push_back(WindowSize(false, 1920, 1440));


		aspect.push_back(WindowAspect(16, 9));
		aspect.push_back(WindowAspect(4, 3));
		aspect.push_back(WindowAspect(5, 4));
		aspect.push_back(WindowAspect(235, 100));
		aspect.push_back(WindowAspect(185, 100));
	}
	std::vector<WindowZoom> zoom; // {
	std::vector<WindowSize> size; // TCY
	std::vector<WindowAspect> aspect; // AXyNg
};


// 擾@
enum DATETIME_TYPE {
	DATETIME_TYPE_NONE = 0, // 擾Ȃ
	DATETIME_TYPE_FILETIME = 1, // t@C쐬擾
	DATETIME_TYPE_FILENAME = 2, // t@C琳K\Ŏ擾
};

enum DATETIME_DATE_FORMAT {
	DATETIME_DATE_FORMAT_NONE = 0,
	DATETIME_DATE_FORMAT_ENGLISH = 1,
	DATETIME_DATE_FORMAT_KANJI = 2,
};

enum DATETIME_TIME_FORMAT {
	DATETIME_TIME_FORMAT_24 = 0,
	DATETIME_TIME_FORMAT_12_ENGLISH = 1,
	DATETIME_TIME_FORMAT_12_KANJI = 2,
};

// \
struct DatetimeConfig {
	DatetimeConfig()
		: type(DATETIME_TYPE_FILENAME)
		, exp(L"(\\d{4})(\\d{2})(\\d{2})\\D*(\\d{2})(\\d{2})(\\d{2})")
		, dateFormat(DATETIME_DATE_FORMAT_KANJI)
		, timeFormat(DATETIME_TIME_FORMAT_24)
	{
		sub[0] = 1;
		sub[1] = 2;
		sub[2] = 3;
		sub[3] = 4;
		sub[4] = 5;
		sub[5] = 6;
	}

	int type; // 擾@
	std::wstring exp; // 擾K\
	std::array<int, 6> sub; // 擾K\

	int dateFormat; // t
	int timeFormat; // ԏ
};


// `l
struct InformationConfig : public network::InformationControl {
};


// Xe[^Xo[CAEg
struct StatusConfig {
	StatusConfig()
		: marginX(4)
		, marginY(2)
	{
		CFont f;
		if (utl::createFont(f))
		{
			f.GetLogFont(&font);
			f.DeleteObject();
		}

		text[0] = RGB(255, 255, 255);

		color[0] = RGB(32, 32, 32);
		color[1] = RGB(0, 0, 0);
		color[2] = RGB(32, 32, 32);
		color[3] = RGB(0, 0, 0);
	}

	LOGFONT font; // tHg

	int marginX; // }[W
	int marginY; // }[Wc
	std::array<COLORREF, 1> text; // F
	std::array<COLORREF, 4> color; // zF
};

// V[No[CAEg
struct SeekConfig {
	SeekConfig()
		: marginX(4)
		, marginY(2)
		, knob(5)
	{
		CFont f;
		if (utl::createFont(f))
		{
			f.GetLogFont(&font);
			f.DeleteObject();
		}

		text[0] = RGB(255, 255, 255);
		text[1] = RGB(180, 180, 180);

		color[0] = RGB(0, 0, 0);
		color[1] = RGB(128, 128, 128);
		color[2] = RGB(0, 0, 0);
		color[3] = RGB(32, 32, 32);
		color[4] = RGB(0, 0, 0);
		color[5] = RGB(255, 255, 255);
		color[6] = RGB(96, 96, 96);
		color[7] = RGB(32, 32, 32);
		color[8] = RGB(0, 0, 0);
		color[9] = RGB(0, 0, 0);
	}

	LOGFONT font; // tHg

	int marginX; // }[W
	int marginY; // }[Wc
	int knob; // mu
	std::array<COLORREF, 2> text; // F
	std::array<COLORREF, 10> color; // zF
};

// V[NqgCAEg
struct HintConfig {
	HintConfig()
		: marginX(4)
		, marginY(2)
	{
		CFont f;
		if (utl::createFont(f, true))
		{
			f.GetLogFont(&font);
			f.DeleteObject();
		}

		text[0] = RGB(255, 255, 255);

		color[0] = RGB(64, 64, 64);
		color[1] = RGB(0, 0, 0);
		color[2] = RGB(64, 64, 64);
		color[3] = RGB(96, 96, 96);
		color[4] = RGB(64, 64, 64);
		color[5] = RGB(0, 0, 0);
	}

	struct Opaque {
		Opaque()
			: enable(true)
			, text(224)
			, back(192)
		{}

		bool enable;
		int text;
		int back;
	};

	LOGFONT font; // tHg

	int marginX; // }[W
	int marginY; // }[Wc
	Opaque opaque; // sx
	std::array<COLORREF, 1> text; // F
	std::array<COLORREF, 6> color; // zF
};

// `l񃌃CAEg
struct ChannelConfig {
	ChannelConfig()
		: marginX(4)
		, marginY(2)
	{
		CFont f;
		if (utl::createFont(f, true))
		{
			f.GetLogFont(&font);
			f.DeleteObject();
		}

		text[0] = RGB(255, 255, 255);

		color[0] = RGB(64, 64, 64);
		color[1] = RGB(0, 0, 0);
		color[2] = RGB(64, 64, 64);
		color[3] = RGB(96, 96, 96);
		color[4] = RGB(64, 64, 64);
		color[5] = RGB(0, 0, 0);
	}

	struct Opaque {
		Opaque()
			: enable(true)
			, text(224)
			, back(192)
		{}

		bool enable;
		int text;
		int back;
	};

	LOGFONT font; // tHg
	
	int marginX; // }[W
	int marginY; // }[Wc
	Opaque opaque; // sx
	std::array<COLORREF, 1> text; // F
	std::array<COLORREF, 6> color; // zF
};

// BBSo[CAEg
struct BBSConfig {
	// f/Xbh^Cg
	struct Title {
		Title()
			: bold(true)
		{
			text[0] = RGB(255, 0, 0);
		}

		bool bold; // 
		std::array<COLORREF, 1> text; // XbhI̕F
	};

	// ݗ
	struct Edit {
		Edit()
		{
			CFont f;
			if (utl::createFont(f))
			{
				f.GetLogFont(&font);
				f.DeleteObject();
			}
		}

		LOGFONT font; // tHg
	};

	BBSConfig()
		: marginX(4)
		, marginY(2)
	{
		CFont f;
		if (utl::createFont(f))
		{
			f.GetLogFont(&font);
			f.DeleteObject();
		}

		text[0] = RGB(255, 255, 255);

		color[0] = RGB(0, 0, 0);
		color[1] = RGB(32, 32, 32);
		color[2] = RGB(32, 32, 32);
		color[3] = RGB(0, 0, 0);
	}

	LOGFONT font; // tHg

	int marginX; // }[W
	int marginY; // }[Wc
	std::array<COLORREF, 1> text; // F
	std::array<COLORREF, 4> color; // zF

	Title title; // f/Xbh^Cg
	Edit edit; // ݗ
};

// X|bvAbvCAEg
struct ResConfig {
	// X
	enum FORMAT {
		FORMAT_NORMAL1, // m[}
		FORMAT_NORMAL2, // m[}iftHĝ݁j
		FORMAT_SIMPLE1, // Vv
		FORMAT_SIMPLE2, // VviftHĝ݁j
		FORMAT_COMPACT1, // RpNg
		FORMAT_COMPACT2, // RpNgiftHĝ݁j
		FORMAT_COUNT, // enum
	};

	// ؂蕶
	enum PUNCT {
		PUNCT_NONE, // Ȃ
		PUNCT_SPACE, // Xy[X
		PUNCT_COLON, // R
		PUNCT_COUNT, // enum
	};

	// 
	struct Format {
		Format()
			: type(FORMAT_NORMAL1)
			, space(2)
			, width(300)
			, punct(PUNCT_COLON)
			, second(false)
		{
			CFont f;
			if (utl::createFont(f, false))
			{
				f.GetLogFont(&font);
				f.DeleteObject();
			}
		}

		int type; // X
		int space; // s
		int width; // {̍ő啝i0Ŗj
		int punct; // ؂蕶
		bool second; // ԁiVvj̕b\
		LOGFONT font; // tHg
	};

	// ID
	struct ID {
		ID()
			: enable(true)
			, threshold(5)
		{}

		bool enable; // ID̉ɔ񐔂\
		int threshold; // ID̂l
	};

	// zF
	struct Color {
		Color()
		{
			text[0] = RGB(0, 0, 0);
			text[1] = RGB(0, 128, 0);
			text[2] = RGB(0, 128, 0);
			text[3] = RGB(0, 0, 0);
			text[4] = RGB(0, 0, 0);
			text[5] = RGB(0, 0, 0);
			text[6] = RGB(0, 0, 0);
			text[7] = RGB(0, 128, 0);
			text[8] = RGB(0, 0, 0);
			text[9] = RGB(0, 0, 0);
			text[10] = RGB(0, 0, 0);

			link[0] = RGB(0, 0, 0);
			link[1] = RGB(0, 0, 255);
			link[2] = RGB(0, 0, 255);
			link[3] = RGB(0, 0, 0);
			link[4] = RGB(0, 0, 0);
			link[5] = RGB(0, 0, 0);
			link[6] = RGB(0, 0, 0);
			link[7] = RGB(0, 0, 255);
			link[8] = RGB(0, 0, 0);
			link[9] = RGB(0, 0, 0);
			link[10] = RGB(0, 0, 255);

			sage[0] = RGB(0, 0, 0);
			sage[1] = RGB(128, 0, 128);
			sage[2] = RGB(128, 0, 128);
			sage[3] = RGB(0, 0, 0);
			sage[4] = RGB(0, 0, 0);
			sage[5] = RGB(0, 0, 0);
			sage[6] = RGB(0, 0, 0);
			sage[7] = RGB(128, 0, 128);
			sage[8] = RGB(0, 0, 0);
			sage[9] = RGB(0, 0, 0);
			sage[10] = RGB(255, 0, 0);

			bold[0] = FALSE;
			bold[1] = TRUE;
			bold[2] = FALSE;
			bold[3] = FALSE;
			bold[4] = FALSE;
			bold[5] = FALSE;
			bold[6] = FALSE;
			bold[7] = FALSE;
			bold[8] = FALSE;
			bold[9] = FALSE;
			bold[10] = FALSE;
		}

		// 00:Xԍ
		// 01:O
		// 02:[
		// 03:
		// 04:ID
		// 05:{
		// 06:Xԍ(Vv/RpNg)
		// 07:(Vv/RpNg)
		// 08:؂蕶
		// 09:[
		// 10:IDwb_

		std::array<COLORREF, 11> text; // [ȂF
		std::array<COLORREF, 11> link; // [蕶F
		std::array<COLORREF, 11> sage; // [sageF
		std::array<BOOL, 11> bold; // 
	};

	// X敪
	struct Box {
		Box()
			: marginX(4)
			, marginY(4)
			, space(1)
			, punct(false)
			, separate(0)
		{
			color[0] = RGB(248, 248, 248);
			color[1] = RGB(248, 248, 248);
			color[2] = RGB(248, 248, 248);
			color[3] = RGB(248, 248, 248);
			color[4] = RGB(248, 248, 248);
			color[5] = RGB(248, 248, 248);

			latest[0] = RGB(224, 224, 255);
			latest[1] = RGB(224, 224, 255);
			latest[2] = RGB(224, 224, 255);
			latest[3] = RGB(224, 224, 255);
			latest[4] = RGB(224, 224, 255);
			latest[5] = RGB(224, 224, 255);
		}

		int marginX; // }[W
		int marginY; // }[Wc
		int space; // Ԃ̗]
		bool punct; // \
		int separate; // 
		std::array<COLORREF, 6> color; // zF
		std::array<COLORREF, 6> latest; // VzF
	};

	// wi
	struct Back {
		Back()
			: marginX(1)
			, marginY(1)
		{
			color[0] = RGB(192, 192, 192);
			color[1] = RGB(192, 192, 192);
			color[2] = RGB(50, 50, 50);
			color[3] = RGB(50, 50, 50);
			color[4] = RGB(50, 50, 50);
			color[5] = RGB(50, 50, 50);
		}

		struct Opaque {
			Opaque()
				: enable(false)
				, text(255)
				, back(224)
			{}

			bool enable;
			int text;
			int back;
		};

		int marginX; // }[W
		int marginY; // }[Wc
		Opaque opaque; // sx
		std::array<COLORREF, 6> color; // zF
	};

public:
	Format format; // X
	ID id; // ID
	Color color; // zF
	Box box; // X敪
	Back back; // wi
};



typedef std::pair<std::wstring, StatusConfig> StatusPair;
typedef std::pair<std::wstring, SeekConfig>  SeekPair;
typedef std::pair<std::wstring, HintConfig> HintPair;
typedef std::pair<std::wstring, ChannelConfig> ChannelPair;
typedef std::pair<std::wstring, BBSConfig> BBSPair;
typedef std::pair<std::wstring, ResConfig> ResPair;

// JX^CAEg
struct CustomDisplayConfig {
	std::vector<StatusPair> status;
	std::vector<SeekPair> seek;
	std::vector<HintPair> hint;
	std::vector<ChannelPair> channel;
	std::vector<BBSPair> bbs;
	std::vector<ResPair> res;
};



struct DisplayConfig {
	CustomDisplayConfig custom; // JX^CAEg

	WindowConfig window; // EBhE
	DatetimeConfig datetime; // \
	InformationConfig information; // `l

	StatusConfig status; // Xe[^Xo[CAEg
	SeekConfig seek; // V[No[CAEg
	HintConfig hint; // V[NqgCAEg
	ChannelConfig channel; // `l񃌃CAEg
	BBSConfig bbs; // BBSo[CAEg
	ResConfig res; // X|bvAbvCAEg
};

} // namespace sl