#pragma once

#ifdef _WIN32_WCE
#error "CCustomDHtmlDialog  Windows CE ł̓T|[gĂ܂B"
#endif 

#include "CustomDHtmlDialog.h"
#include "BrowserHook.h"
#include "BrowserMenu.h"


#include <strsafe.h>

struct PopupBrowserConfig {
	struct Popup {
		Popup()
			: enable(true)
			, limit(1000)
			, head(true)
		{}
		bool enable; // |bvAbv\
		int limit; // \X
		bool head; // ]擪폜ĐVXD\
	};

	struct PopupAnchor : public Popup {
		PopupAnchor() { head = false; }
	};

	struct PopupID : public Popup {
		PopupID() { limit = 10; }
	};

	PopupBrowserConfig()
		: delay(50)
		, edge(true)
		, border(RGB(0, 0, 0))
	{}

	int delay; // |bvAbv܂ł̎
	bool edge; // 3DGbW
	COLORREF border; // {[_[J[
	Popup ref; // Xԍ|bvAbv
	PopupAnchor anchor; // AJ[|bvAbv
	PopupID id; // ID|bvAbv
};

// CPopupBrowserDlg _CAO

class CPopupBrowserDlg : public CCustomDHtmlDialog
{
	DECLARE_DYNCREATE(CPopupBrowserDlg)

public:
	CPopupBrowserDlg(CCustomDHtmlDialog* pParent = NULL, CCustomDHtmlDialog* pTarget = NULL);   // WRXgN^[
	virtual ~CPopupBrowserDlg();

	void SizeHelper();

// _CAO f[^
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_POPUP_BROWSER, IDH = IDR_HTML_POPUP_BROWSER };
#endif

public:
	void setTarget(CCustomDHtmlDialog* dhtml) { target_ = dhtml; }

	void onMouseMove();
	bool onMouseLeave();

	void hide();

	BOOL popup(const CRect& area, const PopupBrowserConfig& cfg, bool margin = false);
	BOOL popup(IHTMLElement* pElement, const PopupBrowserConfig& cfg);

protected:
	BOOL popup(CPopupBrowserDlg* parent, IHTMLElement* pElement, const PopupBrowserConfig& cfg);

	void createPopup();
	void destroyPopup();
	BOOL preparePopup(const CRect& area);
	BOOL preparePopup(IHTMLElement* pElement);

protected:
	PopupBrowserConfig cfg_;
	CCustomDHtmlDialog* target_;
	CCustomDHtmlDialog* parent_;
	CPopupBrowserDlg* popup_;
	int counter_;

	struct This {
		This()
			: header(false)
			, complete(false)
			, callback(false)
			, parent(NULL)
			, margin(true)
			, horizontal(true)
			, show(false)
			, readOnly(false)
			, hover(false)
			, capture(false)
			, cancel(false)
		{}

		bool header;//VKheaderǂݍ
		bool complete;//OnDocumentComplete
		bool callback;//extractCallback

		CPopupBrowserDlg* parent;
		std::wstring url;//XbhURL
		std::wstring extract;//oΏ
		CRect target;//|bvAbvʒu
		bool margin;//|bvAbv}[W
		bool horizontal;//|bvAbvʒuL
		bool show;//|bvAbv\
		DWORD time;//|bvAbv
		bool readOnly;//\̂
		bool hover;//TrackMouseEvent
		bool capture;//}EXLv`
		bool cancel;//|bvAbvLZ
	} this_;

	bool calcScrollSize(CSize& size);
	bool calcWindowSize(const CSize& scroll, CSize& size);
	void setPosition();
	void setShowWindow(bool show);
	void showWindow();
	void showWindow(bool show);
	void delayShowWindow();
	void scrollIntoView(int res);
	void capture(bool enable);
	void cancel(bool enable);
	void beginCapture();
	void endCapture();
	bool checkURL();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	DECLARE_DHTML_EVENT_MAP()
public:
	afx_msg void OnCallbackExtract();
	virtual void OnDocumentComplete(LPDISPATCH pDisp, LPCTSTR szUrl);
	virtual STDMETHODIMP TranslateAccelerator(LPMSG lpMsg, const GUID * pguidCmdGroup, DWORD nCmdID);
	virtual STDMETHODIMP ShowContextMenu( DWORD dwID, POINT* ppt, IUnknown* pcmdtReserved, IDispatch* pdispReserved);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnMouseLeave();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg HRESULT OnAnchorMouseClick(IHTMLElement *pElement);
	afx_msg HRESULT OnAnchorMouseOver(IHTMLElement *pElement);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnContextClose();
};
