// OptionDlg.cpp : t@C
//

#include "stdafx.h"
#include "PCRPlayer.h"
#include "OptionDlg.h"
#include "afxdialogex.h"


// COptionDlg _CAO

IMPLEMENT_DYNAMIC(COptionDlg, CDialog)

COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
	, select_(0)
{

}

COptionDlg::~COptionDlg()
{
}

void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE, m_xcTree);
	DDX_Control(pDX, IDC_TITLE, m_xcTitle);
}

void COptionDlg::createItem(const Item& item)
{
	if (!::IsWindow(item.dlg->GetSafeHwnd()))
	{
		item.dlg->Create(item.idd, this);
		item.dlg->SetWindowPos(NULL, pos_.x, pos_.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	}
	item.dlg->ShowWindow(SW_SHOW);
	setTitle(item.title);
}

void COptionDlg::setTitle(const std::wstring& title)
{
	SetWindowText((L"IvV - " + title).c_str());
	m_xcTitle.SetWindowText(title.c_str());
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	ON_WM_CTLCOLOR()
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, &COptionDlg::OnTvnSelchangedTree)
END_MESSAGE_MAP()


// COptionDlg bZ[W nh[


BOOL COptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	namespace fs = boost::filesystem;

	std::vector<std::wstring> skins;
	if (utl::getFolderPath(gl_.current + L"skin\\", skins))
	{
		for (auto it = skins.begin(); it != skins.end(); ++it)
		{
			*it = fs::path(*it).filename().wstring();
		}

		detail_.bbs.browser.dlg_.skin.thread.setSkins(skins);
		detail_.bbs.browser.dlg_.skin.popup.setSkins(skins);
	}

	//----------------------------------------------------------

	auto parent = [this](const std::wstring& text)->HTREEITEM {
		HTREEITEM item = m_xcTree.InsertItem(text.c_str());
		m_xcTree.SetItemState(item, TVIS_BOLD|TVIS_EXPANDED, TVIS_BOLD|TVIS_EXPANDED);
		return item;
	};

	auto bind = [this](HTREEITEM parent, const std::wstring& text, CDialog* dlg, int idd)->bool {
		if (dlg == NULL) { return false; }
		auto item = m_xcTree.InsertItem(text.c_str(), parent);

		Item tmp = { item, text, dlg, idd };
		items_.push_back(tmp);
		return true;
	};

	//----------------------------------------------------------

	HTREEITEM item = NULL;

	item = parent(L"fݒ");
	bind(item, L"f",				&video_.adjust, CVideoAdjustDlg::IDD);

	item = parent(L"ڍאݒ");
	bind(item, L"lbg[N",			&detail_.network, CDetailNetworkDlg::IDD);
	bind(item, L"^Cv",				&detail_.type, CDetailTypeDlg::IDD);
	bind(item, L"fR[_",				&detail_.decoder, CDetailDecoderDlg::IDD);
	bind(item, L"uEU",				&detail_.browser, IDD_BASE_PROP_WIDE);
	bind(item, L"XibvVbg",		&detail_.snapshot, IDD_BASE_PROP_WIDE);
	bind(item, L"N",				&detail_.start, IDD_BASE_PROP_WIDE);
	bind(item, L"I",				&detail_.end, CDetailEndDlg::IDD);

	item = parent(L"BBSݒ");
	bind(item, L"",					&detail_.bbs.common, CDetailBBSCommonDlg::IDD);
	bind(item, L"BBSo[",				&detail_.bbs.bar, CDetailBBSBarDlg::IDD);
	bind(item, L"BBSuEU",		&detail_.bbs.browser, CDetailBBSBrowserDlg::IDD);
	
	item = parent(L"ݒ");
	bind(item, L"V[gJbg",		&operation_.shortcut, COperationShortcutDlg::IDD);
	bind(item, L"}EX",				&operation_.mouse, IDD_BASE_PROP_WIDE);
	bind(item, L"zC[ω",		&operation_.variation, IDD_BASE_PROP_WIDE);
	bind(item, L"EBhE",			&operation_.window, IDD_BASE_PROP_WIDE);

	item = parent(L"\ݒ");
	bind(item, L"{/TCY",			&display_.window, CDisplayWindowDlg::IDD);
	bind(item, L"AXyNg",			&display_.aspect, CDisplayAspectDlg::IDD);
	bind(item, L"",					&display_.datetime, CDisplayDatetimeDlg::IDD);
	bind(item, L"`l",		&display_.information, CDisplayInformationDlg::IDD);

	item = parent(L"CAEg");
	bind(item, L"Xe[^Xo[",		&display_.status, CDisplayStatusDlg::IDD);
	bind(item, L"V[No[",			&display_.seek, CDisplaySeekDlg::IDD);
	bind(item, L"V[Nqg",			&display_.hint, CDisplayHintDlg::IDD);
	bind(item, L"`l",		&display_.channel, CDisplayChannelDlg::IDD);
	bind(item, L"BBSo[",				&display_.bbs, CDisplayBBSDlg::IDD);
	bind(item, L"X|bvAbv",		&display_.res, CDisplayResDlg::IDD);

	//----------------------------------------------------------

	int marginX = 16, marginY = 8;
	int x = 0, y = 0;

	CRect rc;
	m_xcTree.GetWindowRect(&rc);
	x = rc.Width();
	m_xcTitle.GetWindowRect(&rc);
	y = rc.Height();

	pos_.SetPoint(x + marginX, y + marginY);

	try {
		Item i = items_.at(select_);
		createItem(i);
		m_xcTree.SetItemState(i.item, TVIS_SELECTED, TVIS_SELECTED);
		m_xcTree.EnsureVisible(i.item);
	} catch (...) {}

	//	LOGFONT lf;
	//	GetFont()->GetLogFont(&lf);
	//	lf.lfWeight = FW_BOLD;
	//	font_.CreateFontIndirect(&lf);
	//	m_xcTitle.SetFont(&font_);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


BOOL COptionDlg::PreTranslateMessage(MSG* pMsg)
{
	return CDialog::PreTranslateMessage(pMsg);
}


HBRUSH COptionDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:  DC ̑ύXĂB
	if (nCtlColor == CTLCOLOR_STATIC)
	{
		if (pWnd && *pWnd == m_xcTitle)
		{
			// F
			pDC->SetTextColor(GetSysColor(COLOR_HIGHLIGHTTEXT));
			// wiF
			pDC->SetBkColor(GetSysColor(COLOR_HIGHLIGHT));
			// wiF
			hbr = GetSysColorBrush(COLOR_HIGHLIGHT);
		}
	}
	// TODO: lgpȂꍇ͕ʂ̃uVԂ܂B
	return hbr;
}

void COptionDlg::OnTvnSelchangedTree(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	HTREEITEM item = pNMTreeView->itemNew.hItem;

	HTREEITEM parent = m_xcTree.GetParentItem(item);

	if (parent)
	{
		int i = 0;
		for (auto it = items_.begin(); it != items_.end(); ++it)
		{
			if (it->dlg)
			{
				if (it->item == item)
				{
					createItem(*it);
					select_ = i;
				}
				else
				{
					if (::IsWindow(it->dlg->GetSafeHwnd()))
					{
						it->dlg->ShowWindow(SW_HIDE);
					}
				}
			}
			++i;
		}
	}

	if (pResult) { *pResult = 0; }
}

