// DisplayInformationGeneralDlg.cpp : t@C
//

#include "stdafx.h"
#include "PCRPlayer.h"
#include "DisplayInformationGeneralDlg.h"
#include "afxdialogex.h"


// CDisplayInformationGeneralDlg _CAO

IMPLEMENT_DYNAMIC(CDisplayInformationGeneralDlg, CBasePropDlg)

CDisplayInformationGeneralDlg::CDisplayInformationGeneralDlg(utl::PropSetting& setting, sl::InformationConfig& information)
	: CBasePropDlg(setting)
	, cfg_(information)
{

}

CDisplayInformationGeneralDlg::~CDisplayInformationGeneralDlg()
{
}

void CDisplayInformationGeneralDlg::DoDataExchange(CDataExchange* pDX)
{
	CBasePropDlg::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CDisplayInformationGeneralDlg, CBasePropDlg)
END_MESSAGE_MAP()


// CDisplayInformationGeneralDlg bZ[W nh[

BOOL CDisplayInformationGeneralDlg::OnInitDialog()
{
	CBasePropDlg::OnInitDialog();

	auto bindInfo = [&](CMFCPropertyGridProperty* group, sl::InformationConfig::Channel& value){
		auto check = prop_.check(L"`l", value.name);
		group->AddSubItem(check);
		check = prop_.check(L"^Cv", value.type);
		group->AddSubItem(check);
		check = prop_.check(L"W", value.genre);
		group->AddSubItem(check);
		check = prop_.check(L"ڍ", value.desc);
		group->AddSubItem(check);
		check = prop_.check(L"Rg", value.comment);
		group->AddSubItem(check);
		check = prop_.check(L"A[eBXg", value.artist);
		group->AddSubItem(check);
		check = prop_.check(L"^Cg", value.title);
		group->AddSubItem(check);
		check = prop_.check(L"Ao", value.album);
		group->AddSubItem(check);
	};

	auto group = prop_.group(L"`lu(Xe[^Xo[)");
	prop_.add(group);
	{
		bindInfo(group, cfg_.status);
	}

	group = prop_.group(L"`lu(|bvAbv)");
	prop_.add(group);
	{
		bindInfo(group, cfg_.panel);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
				  // O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CDisplayInformationGeneralDlg::OnGetProp()
{
	prop_.get();
}

void CDisplayInformationGeneralDlg::OnSetProp()
{
	auto tmp = network::InformationControl();
	cfg_.status = tmp.status;
	cfg_.panel = tmp.panel;
	prop_.set();
}

