// DetailBBSCommonNetworkDlg.cpp : t@C
//

#include "stdafx.h"
#include "PCRPlayer.h"
#include "DetailBBSCommonNetworkDlg.h"
#include "afxdialogex.h"


// CDetailBBSCommonNetworkDlg _CAO

IMPLEMENT_DYNAMIC(CDetailBBSCommonNetworkDlg, CBasePropDlg)

CDetailBBSCommonNetworkDlg::CDetailBBSCommonNetworkDlg(utl::PropSetting& setting, sl::BoardConfig& board)
	: CBasePropDlg(setting)
	, cfg_(board)
{

}

CDetailBBSCommonNetworkDlg::~CDetailBBSCommonNetworkDlg()
{
}

void CDetailBBSCommonNetworkDlg::DoDataExchange(CDataExchange* pDX)
{
	CBasePropDlg::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CDetailBBSCommonNetworkDlg, CBasePropDlg)
END_MESSAGE_MAP()


// CDetailBBSCommonNetworkDlg bZ[W nh[

BOOL CDetailBBSCommonNetworkDlg::OnInitDialog()
{
	CBasePropDlg::OnInitDialog();

	auto group = prop_.group(L"HTTP");
	prop_.add(group);
	{
		auto string = prop_.string(L"UserAgent", cfg_.userAgent);
		group->AddSubItem(string);

		auto number = prop_.number(L"^CAEg(~b)", cfg_.timeout);
		number->EnableSpinControl(TRUE, 0, 60000);
		group->AddSubItem(number);
	}

	group = prop_.group(L"Proxy");
	prop_.add(group);
	{
		auto string = prop_.string(cfg_.proxy.get.enable, L"ǂݍݗpProxy", cfg_.proxy.get.name);
		group->AddSubItem(string);

		string = prop_.string(cfg_.proxy.post.enable, L"ݗpProxy", cfg_.proxy.post.name);
		group->AddSubItem(string);

		string = prop_.string(L"LɂzXg(K\)", cfg_.proxy.white);
		group->AddSubItem(string);

		string = prop_.string(L"ɂzXg(K\)", cfg_.proxy.black);
		group->AddSubItem(string);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
				  // O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CDetailBBSCommonNetworkDlg::OnGetProp()
{
	prop_.get();
}

void CDetailBBSCommonNetworkDlg::OnSetProp()
{
	auto tmp = sl::BoardConfig();
	cfg_.userAgent = tmp.userAgent;
	cfg_.timeout = tmp.timeout;
	cfg_.proxy = tmp.proxy;

	prop_.set();
}
