#include "stdafx.h"



namespace dsp {

AsyncBufferingLoader::AsyncBufferingLoader()
: timeout_(10000)
, terminated_(false)
, total_(0)
, consume_(false)
{
		
}

AsyncBufferingLoader::~AsyncBufferingLoader()
{
	// Iɒ~łȂ̂
	// Œ~Kv
	terminate();
}


// obt@OJnď
// f[^̐擪ǂŃ^Cv̔ʂ
bool AsyncBufferingLoader::execute(const std::wstring& url, const std::wstring& userAgent, int timeout)
{
	terminate();


	// 
	{
		boost::recursive_mutex::scoped_lock lock(mutex_);
		
		timeout_ = timeout;
		terminated_ = false;
		total_ = 0;
		lead_.clear();
		buffer_.clear();
	}

	{
		boost::recursive_mutex::scoped_lock lock(mutexClient_);
		client_.close();
		if (!client_.open(url, userAgent, network::Proxy(), timeout)) return false;
	}


	// 擪f[^𓯊œǂݍł
	size_t size = 0;
	while (size < 1024)// lȏǂݍ
	{
		std::vector<char> tmp;
		int state = network::HttpClient::STATE_ERROR;
		{
			boost::recursive_mutex::scoped_lock lock(mutexClient_);
			state = client_.recv(tmp);
		}

		// I͏I[Ńf[^łȂ΃obt@ɒǉ
		if ((state == network::HttpClient::STATE_OK || state == network::HttpClient::STATE_EOF) && !tmp.empty())
		{
			boost::recursive_mutex::scoped_lock lock(mutex_);
			lead_.insert(lead_.end(), tmp.begin(), tmp.end());
			size += lead_.size();
		}

		// IłȂΏI
		if (state != network::HttpClient::STATE_OK)
		{
			boost::recursive_mutex::scoped_lock lock(mutexClient_);
			client_.close();
			return true;
		}
	}

	// Xbh 񓯊
	boost::thread thr(&AsyncBufferingLoader::buffering, this);
	mainloop_.detach();
	mainloop_.swap(thr);
	return true;
}

// obt@O~
void AsyncBufferingLoader::terminate()
{
	{
		boost::recursive_mutex::scoped_lock lock(mutex_);
		if (terminated_) { return; }
		terminated_ = true;
	}

	if (mainloop_.joinable())
	{
		mainloop_.interrupt(); // Xbhf
		//DebugText(L"AsyncBufferingLoader::thread_.interrupt();\n");
		mainloop_.join(); // f܂őҋ@
		//DebugText(L"AsyncBufferingLoader::thread_.join();\n");
	}
}

// obt@O~Ă
bool AsyncBufferingLoader::terminated()
{
	boost::recursive_mutex::scoped_lock lock(mutex_);
	return terminated_;
}

// w肵ȏ̃f[^Ƃ܂őҋ@
// ^CAEg邩~߂璆f
bool AsyncBufferingLoader::fill(LONGLONG length)
{
	if (!client_) { return false; }

	clock_t time = clock();
	while (size() < length)
	{
		Sleep(1);

		if (terminated_)
		{
			return false;
		}

		if ((clock() - time) > timeout_)
		{
			return false;
		}
	}
	return true;
}

LONGLONG AsyncBufferingLoader::size()
{
	boost::recursive_mutex::scoped_lock lock(mutex_);
	return total_;
}


// obt@ɃRs[
size_t AsyncBufferingLoader::lead(void *dst, size_t size)
{
	boost::recursive_mutex::scoped_lock lock(mutex_);
	if (lead_.size() < size)
	{
		size = lead_.size();
	}
		
	CopyMemory(dst, lead_.data(), size);
	return size;
}

// obt@ɃRs[
size_t AsyncBufferingLoader::copy(void *dst, LONGLONG pos, LONG length)
{
	boost::recursive_mutex::scoped_lock lock(mutex_);
	if (!consume_)
	{
		if ((int)buffer_.size() < pos + length)
		{
			CopyMemory(dst, buffer_.data(), buffer_.size());
			return buffer_.size();
		}

		CopyMemory(dst, buffer_.data() + pos, length);
		return length;
	}
	else
	{
		// Ŝ猻݂̃obt@ʒu擪
		// Rs[ʒu擪ƃobt@̃Rs[ʒuɂȂ
		LONG current = (LONG)(pos - (total_ - buffer_.size()));

		// Rs[ʒuobt@O
		if (current < 0)
		{
			//DebugText(L"AsyncBufferingLoader::copy(fail current)\n");
			return 0;
		}

		// Rs[obt@傫
		if (buffer_.size() < (size_t)(current + length))
		{
			// obt@̃TCYɐ؂l
			length = (LONG)buffer_.size() - current;
		}

		// Rs[ʒuobt@TCY𒴂Ăꍇ}CiXɂȂ邱Ƃ邪
		// ʏfillĂĂ΂̂Ń}CiXɂȂȂ
		if (length < 0)
		{
			//DebugText(L"AsyncBufferingLoader::copy(fail length)\n");
			return 0;
		}
		
		CopyMemory(dst, buffer_.data() + current, length);
		
		// 擪Rs[͈͂܂ł폜
		std::vector<char> tmp(buffer_.begin() + current + length, buffer_.end());
		std::swap(buffer_, std::move(tmp));

		//DebugText(L"buffer_.size:%d\n", buffer_.size());
		return length;
	}
}

// Rs[ɐ؂ւ
// MemSourceFilter::CompleteConnect
// fBA^Cv`FbNĐڑ
// Rs[ɐ؂ւ
void AsyncBufferingLoader::consume(bool enable)
{
	boost::recursive_mutex::scoped_lock lock(mutex_);
	consume_ = enable;
}

// obt@O{
void AsyncBufferingLoader::buffering()
{
	{
		// 擪f[^Rs[
		boost::recursive_mutex::scoped_lock lock(mutex_);
		total_ = lead_.size();
		buffer_ = lead_;
	}

	try {
		while (true)
		{
			boost::this_thread::interruption_point();

			// f[^ǂݍ
			std::vector<char> tmp;
			int state = network::HttpClient::STATE_ERROR;
			{
				boost::recursive_mutex::scoped_lock lock(mutexClient_);
				state = client_.recv(tmp);
			}

			boost::this_thread::interruption_point();
			
			
			// I͏I[Ńf[^łȂ΃obt@ɒǉ
			if ((state == network::HttpClient::STATE_OK || state == network::HttpClient::STATE_EOF) && !tmp.empty())
			{
				boost::recursive_mutex::scoped_lock lock(mutex_);
				
				total_ += tmp.size();
				buffer_.insert(buffer_.end(), tmp.begin(), tmp.end());
			}

			// IłȂΏI
			if (state != network::HttpClient::STATE_OK)
			{
				break;
			}
		}
	}
	catch(...){}

	{
		boost::recursive_mutex::scoped_lock lock(mutex_);
		terminated_ = true;
	}
	{
		boost::recursive_mutex::scoped_lock lock(mutexClient_);
		client_.close();
	}
}


} // namespace dsp

